package com.vmware.samples.viewspropertiesui.views {

import com.vmware.core.model.IResourceReference;
import com.vmware.ui.IContextObjectHolder;

import flash.events.Event;
import flash.events.EventDispatcher;
import flash.events.MouseEvent;

import mx.collections.ArrayCollection;
import mx.controls.Alert;
import mx.logging.Log;
import mx.logging.ILogger;

import com.vmware.core.model.StringDataObject;
import com.vmware.data.query.DataUpdateSpec;
import com.vmware.data.query.events.DataRequestInfo;
import com.vmware.data.query.events.PropertyRequest;


// Meta-tag to register this class as a source of DataRequest
[Event(name="{com.vmware.data.query.events.PropertyRequest.REQUEST_ID}",
      type="com.vmware.data.query.events.PropertyRequest")]
/**
 * The mediator for the VmSampleSummarySectionView view.
 */
public class VmSampleSummarySectionViewMediator extends EventDispatcher implements IContextObjectHolder {

   /** The context object. */
   private var _contextObject:IResourceReference;

   /** The view instance. */
   private var _view:VmSampleSummarySectionView;

   /**
    * Instance logger.
    */
   private static var _logger:ILogger = Log.getLogger("VmSampleSummarySectionViewMediator");

   [View]
   /** The view associated with this mediator. */
   public function set view(value:VmSampleSummarySectionView):void {
      _view = value;
   }

   /**
    * Returns the view.
    */
   public function get view():VmSampleSummarySectionView {
      return _view;
   }

   [Bindable]
   /** Returns the selected VM for this view */
   public function get contextObject():Object {
      return _contextObject;
   }

   public function set contextObject(value:Object):void {
      _contextObject = IResourceReference(value);

      if (_contextObject == null) {
         clearData();
         return;
      }
      requestData();
   }

   /** Send a query to the server to get the guestState for the selected VM */
   private function requestData():void {
      // Use the data request option for implicit updates of the view,
      // i.e. when the object changes for instance.
      var requestInfo:DataRequestInfo =
         new DataRequestInfo(DataUpdateSpec.newImplicitInstance());

      // Use a PropertyRequest to request the value of 1 property
      // "guest" is a property of VirtualMachine, which is a GuestInfo
      // DataObject, and "guestState" is an attribute of GuestInfo.
      var request:PropertyRequest = PropertyRequest.newInstance(
            _contextObject, "guest.guestState", requestInfo);
      dispatchEvent(request);
   }

   /**
    * Handles the response to PropertyRequest above. The method name is not
    * important, only its signature and the ResponseHandler tag are.
    *
    * Note that the result is provided as a StringDataObject (wrapper for String)
    * because one String property was requested.
    **/
   [ResponseHandler(name=
         "{com.vmware.data.query.events.PropertyRequest.RESPONSE_ID}")]
   public function onDataRetrieved(request:PropertyRequest,
            result:StringDataObject, error:Error):void {
      if (error != null) {
         _logger.debug("onDataRetrieved error: " + error.message);
         return;
      }

      // Assigning the result to vmGuestState will update the view.
      _view.vmGuestState = (result != null) ? result.value : null;
   }

   /** Resets the UI */
   private function clearData() : void {
      _view.vmGuestState = null;
   }
} // end class
} // end package

